<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InterviewAttempt extends Model
{
    protected $table = 'interview_attempts';
    protected $primaryKey = 'Interview_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Job_id',
        'Application_id',
        'Scheduled_at',
        'Status',
        'Is_completed',
        'Video_link',
        'Duration_minutes',
        'Interview_type',
        'Interviewer_id',
        'Feedback',
        'integration_id',
    ];

    protected $casts = [
        'Scheduled_at' => 'datetime',
        'Is_completed' => 'boolean',
        'Duration_minutes' => 'integer',
        'Interview_type' => 'string',
        'integration_id' => 'string',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function job(): BelongsTo
    {
        return $this->belongsTo(Job::class, 'Job_id', 'Job_id');
    }

    public function application(): BelongsTo
    {
        return $this->belongsTo(JobApplication::class, 'Application_id', 'Application_id');
    }

    public function interviewer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'Interviewer_id', 'User_id');
    }
}
